#include <iostream>
#include <iomanip>
#include <chrono>

#include "QuicksortMT.h"

using namespace std;
using namespace std::chrono;

int main()
{
    constexpr int DATA_SIZE = 1000000;
    constexpr int MAX_POOL_SIZE = 24;

    int *unsorted_array = new int[DATA_SIZE];
    int *copy_array     = new int[DATA_SIZE];
    double one_thread_ms = 0;

    cout << "Hardware concurrency = "
         << thread::hardware_concurrency() << endl;

    cout << "Generating a random array of size " << DATA_SIZE
         << " ... ";

    srand(time(0));
    for (int i = 0; i < DATA_SIZE; i++) unsorted_array[i] = rand();
    cout << "done" << endl << endl;

    printf("Thread count   Sorting time (msec)   Improvement\n");

    for (int thread_count = 1;
         thread_count <= MAX_POOL_SIZE;
         thread_count++)
    {
        int *u = unsorted_array;
        int *c = copy_array;
        for (int i = 0; i < DATA_SIZE; i++) *(c + i) = *(u + i);

        QuicksortMT quicksorter(copy_array, DATA_SIZE);

        // Time how long it takes to sort, in milliseconds.
        steady_clock::time_point start_time = steady_clock::now();
        quicksorter.sort(thread_count);
        auto end_time = steady_clock::now();
        long ms = duration_cast<milliseconds>(
                                        end_time - start_time).count();

        if (thread_count == 1) one_thread_ms = ms;

        if (ms >= 0)
        {
            printf("%7d%20ld", thread_count, ms);

            if (thread_count > 1)
            {
                double pct = 100*(one_thread_ms - ms)/one_thread_ms;
                printf("%17.1f%%", pct);
            }

            cout << endl;
        }

        // Did the sort succeed?
        if (!quicksorter.verify_sorted())
        {
            cout << "ERROR! Not sorted." << endl;
            break;
        }
    }

    cout << endl << "Done!" << endl;

    delete[] unsorted_array;
    delete[] copy_array;

    return 0;
}
