#ifndef QUICKSORTMT_H_
#define QUICKSORTMT_H_

#include <stack>
#include <atomic>
#include <chrono>
#include <thread>
#include <mutex>
#include <condition_variable>

using namespace std;
using namespace std::chrono;

class QuicksortMT
{
public:
    QuicksortMT(int * const d, const int s)
       : data(d), size(s), thread_pool(nullptr) {}

    void sort( int thread_count);
    bool verify_sorted() const;

private:
    int *data;  // the data array to be sorted
    int size;   // size of the data array

    // How many elements are sorted (shared resource).
    atomic<int> sorted_count;

    // Stack of subarrays to sort (shared resource).
    stack<pair<int, int>> subarray_stack;

    void sort_subarray(int thread_id);
    void process_subarray(const int left_index, const int right_index);
    void push_subarray(const int left_index, const int right_index);
    int  partition(const int left_index, const int right_index);

    // Multithreading objects.
    thread *thread_pool;
    mutex stack_mutex;
    condition_variable sorting_cv;

    // Multithreading conditions.
    bool ok_to_continue() const;
    bool just_became_not_empty() const;
};

#endif /* QUICKSORTMT_H_ */
