#ifndef QUICKSORT_H_
#define QUICKSORT_H_

#include <stack>

using namespace std;

class Quicksort
{
public:
    /**
     * Constructor.
     * @param d the data array.
     * @param s the size of the data array.
     */
    Quicksort(int * const d, const int s)
       : data(d), size(s), sorted_count(0) {}

    void sort();
    bool verify_sorted() const;

private:
    int *data;         // the data array to be sorted
    int size;          // size of the data array
    int sorted_count;  // how many elements are sorted

    // Stack of subarrays to sort.
    stack<pair<int, int>> subarray_stack;

    void sort_subarray();
    void process_subarray(const int left_index, const int right_index);
    void push_subarray(const int left_index, const int right_index);
    int  partition(const int left_index, const int right_index);
};

#endif /* QUICKSORT_H_ */
