#include <iostream>
#include <chrono>

#include "Quicksort.h"

using namespace std;
using namespace std::chrono;

int main()
{
    constexpr int DATA_SIZE = 1000000;
    int *data = new int[DATA_SIZE];

    cout << "Generating a random array of size " << DATA_SIZE
         << " ... ";

    srand(time(0));
    for (int i = 0; i < DATA_SIZE; i++) data[i] = rand();
    cout << "done" << endl << endl;

    Quicksort quicksorter(data, DATA_SIZE);

    // Time how long it takes to sort, in milliseconds.
    auto start_time = steady_clock::now();
    quicksorter.sort();
    auto end_time = steady_clock::now();
    long ms = duration_cast<milliseconds>(
                                    end_time - start_time).count();
    printf("%20ld ms\n", ms);

    // Did the sort succeed?
    if (!quicksorter.verify_sorted())
    {
        cout << "ERROR!" << endl;
    }

    cout << endl << "Done!" << endl;

    delete[] data;
    return 0;
}
