#ifndef QUICKSORT_H_
#define QUICKSORT_H_

class Quicksort
{
public:
    /**
     * Constructor.
     * @param d the data array.
     * @param s the size of the data array.
     */
    Quicksort(int * const d, const int s) : data(d), size(s) {};

    /**
     * Public sort() function to sort the entire array.
     */
    void sort() { sort(0, size-1); }

    bool verify_sorted() const;

protected:
    int *data;  // the data array to be sorted
    int size;   // size of the data array

    int partition(const int left_index, const int right_index);
    void sort(const int left_index, const int right_index);
};

#endif /* QUICKSORT_H_ */
