#include <iostream>

#include "Quicksort.h"

using namespace std;

/**
 * Partition a subarray bounded by its leftmost and rightmost indexes.
 * @param left_index the leftmost index of the subarray.
 * @param right_index the rightmost index of the subarray.
 * @return the index of the pivot element.
 */
int Quicksort::partition(const int left_index, const int right_index)
{
    int middle_index = (left_index + right_index)/2;

    int *mid   = &data[middle_index];
    int *left  = &data[left_index];
    int *right = &data[right_index];

    // Choose the pivot value and swap it with the rightmost element.
    int pivot_value  = data[middle_index];
    std::swap(*mid, *right);

    int *i = left - 1;  // point i to the left end
    int *j = right;     // point j tlo the right end

    do
    {
        while (*(++i) < pivot_value) {}  // move pointer i to the left
        while (*(--j) > pivot_value) {}  // move pointer j to the right

        // Swap the ith and jth elements after i and j stop.
        if (i < j) std::swap(*i, *j);
    } while (i < j);  // break out when i and j cross

    // Swap the pivot element back in.
    std::swap(*i, *right);

    // Return the index of the pivot element.
    return i - &data[0];
}

/**
 * Recursive sort() function. Partition a subarray and
 * recursively sort the resulting two smaller subarrays.
 * @param left_index the leftmost index of this subarray.
 * @param right_index the rightmost index of this subarray.
 */
void Quicksort::sort(const int left_index, const int right_index)
{
    int subarray_size = right_index - left_index + 1;

    // Base cases: Subarray sizes 0, 1, and 2.
    if (subarray_size < 2) return;
    if (subarray_size == 2)
    {
        // Swap them if necessary.
        if (data[left_index] > data[right_index])
        {
            std::swap(data[left_index], data[right_index]);
        }
    }

    // Subarray size > 2: Partition this subarray and
    // recursively sort the resulting two smaller subarrays.
    else
    {
        int pivot_index = partition(left_index, right_index);

        sort(left_index, pivot_index - 1);   // left subarray
        sort(pivot_index + 1, right_index);  // right subarray
    }
}

/**
 * Paranoid programming: Verify that the array was successfully sorted.
 * @return true if sorted, false if not.
 */
bool Quicksort::verify_sorted() const
{
    for (int i = 1; i < size; i++)
    {
        if (data[i] < data[i-1]) return false;
    }

    return true;
}
