#include <iostream>
#include <vector>

#include "Island.h"
#include "Bridge.h"
#include "Path.h"
#include "PathFinder.h"

using namespace std;

int main()
{
    PathFinder path_finder;

    // Get a vector of the cheapest paths from
    // the starting island to the destination island.
    vector<Path *> *cheapest_paths =
            path_finder.find_cheapest_paths(path_finder.get_start());

    if (!cheapest_paths->empty())
    {
        int lowest_cost = (*cheapest_paths)[0]->get_cost();
        cout << "Lowest cost is $" << lowest_cost << endl;

        cout << endl << "Cheapest paths:" << endl;
        for (Path *path :*cheapest_paths)
        {
            int count = path->get_route().size();

            for (int i = count - 1; i >= 0; i--)
            {
                const Island *island = (path->get_route())[i];
                cout << " -> " << island->get_name();
            }

            cout << endl;
            delete path;
        }
    }
    else
    {
        cout << "No paths lead to the destination." << endl;
    }

    delete cheapest_paths;

    cout << endl;
    cout << "Done!" << endl;

    return 0;
}
