#ifndef PATH_H_
#define PATH_H_

#include <vector>
#include "Island.h"

using namespace std;

class Path
{
public:
    Path() : cost(0) {}

    vector<const Island *> const get_route() const { return route; }
    int get_cost() const { return cost; }

    /**
     * Append an island to the path.
     * @param island the island to append.
     */
    void add_island(const Island * const island) { route.push_back(island); }

    /**
     * Increase the cost of this path.
     * @param toll the bridge toll to add to the cost.
     */
    void increase_cost(const int toll) { cost += toll; }

private:
    int cost;                       // sum of tolls on the path
    vector<const Island *> route;   // islands visited on the path
};

#endif /* PATH_H_ */
